<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	
	<xsl:template name="ParameterUMLNotation">
		<xsl:param name="elem"/>

			<xsl:variable name="typeref">
				<xsl:call-template name="typeRefHandler">
					<xsl:with-param name="parameter" select="$elem"></xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="$elem/@Direction">
				<xsl:value-of select="$elem/@Direction"></xsl:value-of>
				<xsl:text> </xsl:text>
			</xsl:if>
			<xsl:value-of select="$elem/@elementName"></xsl:value-of>
			<xsl:text>:</xsl:text>
			<xsl:value-of select="$typeref"></xsl:value-of>
			<xsl:if test="$elem/@Multiplicity">
				<xsl:text>[</xsl:text>
				<xsl:value-of select="$elem/@Multiplicity"></xsl:value-of>
				<xsl:text>]</xsl:text>
			</xsl:if>
			<xsl:if test="$elem/@DefaultValue">
				<xsl:text>=</xsl:text>
				<xsl:value-of select="$elem/@DefaultValue"></xsl:value-of>
			</xsl:if>
	</xsl:template>
	
	<!-- Creates method parentheses including name of parameters -->
	<xsl:template match="Method" mode="method-parentheses">
		<xsl:variable name="params" select="Parameter"></xsl:variable>
		<xsl:variable name="indexer" select="@isIndexer" />
		<xsl:variable name="parentheses">
			<xsl:choose>
				<xsl:when test="$indexer='true'">
					<xsl:text>[</xsl:text>
				</xsl:when>
                        	<xsl:otherwise> 	
					<xsl:text>(</xsl:text>
        	                </xsl:otherwise>
			</xsl:choose>
			<xsl:for-each select="$params">
				<xsl:variable name="typeref">
					<xsl:call-template name="typeRefHandler">
						<xsl:with-param name="parameter" select="current()"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<!--xsl:value-of select="$typeref"></xsl:value-of>
				<xsl:text> </xsl:text>
				<xsl:value-of select="@elementName"></xsl:value-of>
				<xsl:if test="not(position()=last())">
					<xsl:text>, </xsl:text>
				</xsl:if-->
				<xsl:choose>
					<xsl:when test="$prj_lang='csharp'">
						<xsl:value-of select="$typeref"></xsl:value-of>
						<xsl:text> </xsl:text>
						<xsl:value-of select="@elementName"></xsl:value-of>
						<xsl:if test="not(position()=last())">
							<xsl:text>, </xsl:text>
						</xsl:if>
					</xsl:when>
					<xsl:when test="$prj_lang='vbnet'">
						<xsl:value-of select="@elementName"></xsl:value-of>
						<xsl:text> As </xsl:text>
						<xsl:value-of select="$typeref"></xsl:value-of>
						<xsl:if test="not(position()=last())">
							<xsl:text>, </xsl:text>
						</xsl:if>
					</xsl:when>
					<xsl:when test="$prj_lang='delphi'">
						<xsl:value-of select="@elementName"></xsl:value-of>
						<xsl:text>: </xsl:text>
						<xsl:value-of select="$typeref"></xsl:value-of>
						<xsl:if test="not(position()=last())">
							<xsl:text>; </xsl:text>
						</xsl:if>
					</xsl:when>
					<xsl:otherwise>
						<xsl:if test="@Direction">
							<xsl:value-of select="@Direction"></xsl:value-of>
							<xsl:text> </xsl:text>
						</xsl:if>
						<xsl:value-of select="@elementName"></xsl:value-of>
						<xsl:text>:</xsl:text>
						<xsl:value-of select="$typeref"></xsl:value-of>
						<xsl:if test="@Multiplicity">
							<xsl:text>[</xsl:text>
							<xsl:value-of select="@Multiplicity"></xsl:value-of>
							<xsl:text>]</xsl:text>
						</xsl:if>
						<xsl:if test="@DefaultValue">
							<xsl:text>=</xsl:text>
							<xsl:value-of select="@DefaultValue"></xsl:value-of>
						</xsl:if>
						<xsl:if test="not(position()=last())">
							<xsl:text>, </xsl:text>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
			<xsl:choose>
				<xsl:when test="$indexer='true'">
					<xsl:text>]</xsl:text>
				</xsl:when>
                        	<xsl:otherwise> 	
					<xsl:text>)</xsl:text>
        	                </xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:value-of select="string($parentheses)"></xsl:value-of>
	</xsl:template>

	<!-- Creates inner referense to method description (method signature)-->
	<xsl:template match="Method" mode="method-ref">
		<xsl:variable name="m_name" select="@name"></xsl:variable>
		<xsl:variable name="params" select="Parameter"></xsl:variable>
		<xsl:variable name="ref">
			<xsl:value-of select="$m_name"></xsl:value-of>
			<xsl:text>(</xsl:text>
			<xsl:for-each select="$params">
				<xsl:variable name="typeref">
					<xsl:call-template name="typeInnerRefHandler">
						<xsl:with-param name="parameter" select="current()"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="$typeref"></xsl:value-of>
			
				<xsl:if test="not(position()=last())">
					<xsl:text>/</xsl:text>
				</xsl:if>
			</xsl:for-each>
			<xsl:text>)</xsl:text>
		</xsl:variable>
		<xsl:value-of select="string($ref)"></xsl:value-of>
	</xsl:template>
	
	<xsl:template name="typeRefHandler">
		<xsl:param name="parameter"></xsl:param>
		<xsl:choose>
			<xsl:when test="string($parameter/@isPrimitive)='false'">
				<xsl:variable name="element" select="key('all-by-id', string($parameter/@typeref))"></xsl:variable>
				<xsl:choose>
					<xsl:when test="$element">
						<xsl:apply-templates select="$element" mode="HRefWithImgLoad">
							<xsl:with-param name="isName" select="'2'"/>
							<xsl:with-param name="useName">
								<xsl:call-template name="getFQNInContext">
									<xsl:with-param name="element" select="$element"></xsl:with-param>
									<xsl:with-param name="context" select=".."></xsl:with-param>
								</xsl:call-template>
							</xsl:with-param>
						</xsl:apply-templates>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$parameter/@type"></xsl:value-of>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$parameter/@type"></xsl:value-of>
			</xsl:otherwise>
		</xsl:choose>
		
	</xsl:template>

	<xsl:template name="typeInnerRefHandler">
		<xsl:param name="parameter"></xsl:param>
		<xsl:choose>
			<xsl:when test="string($parameter/@isPrimitive)='false'">
				<xsl:variable name="element" select="key('all-by-id', string($parameter/@typeref))"></xsl:variable>
				<xsl:variable name="paramName" select="$element/@name"></xsl:variable>
				<xsl:variable name="systemType" select="string($parameter/@systemType)"></xsl:variable>
				<xsl:choose>
					<xsl:when test="string-length($paramName) &gt; 0">
						<xsl:value-of select="$paramName"></xsl:value-of>
					</xsl:when>
					<xsl:when test="string-length($systemType) &gt; 0">
						<xsl:value-of select="$systemType"></xsl:value-of>
					</xsl:when>
 					<xsl:otherwise>
						<xsl:value-of select="$parameter/@type"></xsl:value-of>
					</xsl:otherwise>
				</xsl:choose>		
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$parameter/@type"></xsl:value-of>
			</xsl:otherwise>
		</xsl:choose>
		
	</xsl:template>
	

</xsl:stylesheet>
